package gov.va.med.mhv.sm.admin.enums;

public enum SystemFolderEnum {

	INBOX (0L, "Inbox", false,1),
	SENT (-1L, "Sent", false,4),
	DRAFTS (-2L, "Drafts", false,3),
	DELETED (-3L, "Deleted", false,6),
	COMPLETED(-4L, "Completed", true,5),
	ESCALATED (-5L, "Escalated", true,2),
	REMINDER(-6L,"Reminder",true,7),
	REASSIGN(-7L,"Reassign",true,8),
	CPRSPROGRESSALERTS(-8L,"CPRS Progress Notes Alerts",true,9);
    
	
	private Long id;
	private String name;
	private boolean clinicianOnly;
	private Integer sortOrder;
	
	private SystemFolderEnum(Long id, String name, 
			boolean clinicianOnly, int sortOrder){
		this.id = id;
		this.name = name;
		this.clinicianOnly = clinicianOnly;
		this.sortOrder = sortOrder;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public boolean isClinicianOnly() {
		return clinicianOnly;
	}
	public void setClinicianOnly(boolean clinicianOnly) {
		this.clinicianOnly = clinicianOnly;
	}
	
	
	public static SystemFolderEnum valueOf(Long value){
		for(SystemFolderEnum f : SystemFolderEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		return INBOX;
	}
	public Integer getSortOrder() {
		return sortOrder;
	}
	public void setSortOrder(Integer sortOrder) {
		this.sortOrder = sortOrder;
	}
	
	
}
